*
* TDBS User Search Utility
* Revision 1.01
* Written by Alan D. Bryant
* for eSoft, Inc.
*
****************************************************************************
* This program source is included with your TDBS to illustrate techniques. *
* You may use any or all of the source or techniques illustrated in this   *
* program in any fashion you wish.  There are no fees or restrictions      *
* imposed on the use of this code by eSoft, Inc.                           *
****************************************************************************
*
* PURPOSE:  This program allows users to search for other users on the
* system using the "soundex" function.  This algorithm allows searches
* to have a match based on the sound of the word (name, in this case)
* provided that the words share the same first letter.
*
* CONCEPTS ILLUSTRATED:  The program illustrates the use of the binary
* file I/O system in TDBS 1.2 as it searches the USERLOG.BBS directly
* file for matches.
*
* FLOW:  The general flow of the program is to prompt the user for a name
* to search for, apply the SOUNDEX() function to it, then rip through
* the USERLOG.BBS file 4k at a time and look at each 512 byte record
* for matches.  The SOUNDEX() is applied to each record to make the
* comparison.  If a match is found, that user's name is displayed.
*
* POSSIBLE ENHANCEMENTS:  As implemented, this program compares the user
* name from the beginning, making it suitable only for finding first
* or whole name on a typical TBBS system.  It could easily be modified
* to match last names instead or in addition to what it's doing now.
* It could also display other user information, such as the location
* or notes fields.
*


*
*
* public declarations

public retval

clear

*
* open userlog file in read-only binary mode
*
fopen handle "userlog.bbs" 0 4096
if handle = -1
    ? "USEARCH: Error on opening USERLOG.BBS"
    ? "USEARCH: Error was: "+message(ferror(handle))
    wait
    quit
endif

*
* user input routine to get name to search for
*
sname = ""
accept "What is the name of the user you'd like to search for? " to sname
? ""
sname = upper(rtrim(sname))

*
* if empty input, exit, otherwise display status
*
if empty(sname)
    quit
endif


? "Searching for users that sound like: "+sname
? "This may take awhile, so please be patient.  If you'd like to abort the"
? "search at any time, press your Esc (escape) key..."
? ""

*
* get soundex code for search name
*
sname = soundex(sname)

*
* establish the time now for a count later on
*
begin = seconds()

*
* establish the initial value of a counter
*
counter = 1


*
* set up a loop to look at each userlog record
*
do while .t.

    *
    * read a record
    *
    fbread handle bytes handle 0 4096

    *
    * if 0 bytes were read, then we're at EOF or there was an error
    * so exit the loop
    *
    if bytes = 0
        exit
    endif

    *
    * setup a loop to process 512 bytes at a time from the buffer
    *
    pass = 1

    do while .t.
        *
        * increment the counter
        *
        counter = counter + 1


        *
        * extract out the name of the user
        *
        readout = fbextract(handle, (pass * 512) - 512 + 1, 50)
        offset = at(chr(0), readout)
        readout = substr(readout, 1, offset - 1)

        *
        * get soundex code for this record
        *
        thisone = soundex(readout)

        *
        * compare this record's soundex with the one we're looking for
        * if they match, display this user's name
        if thisone = sname
            ? readout
        endif

        *
        * increment the pass counter
        * if we've used up all the bytes we read, then go back and read
        * more of them
        *
        pass = pass + 1
        if pass = (bytes / 512) + 1
            exit
        endif
    enddo

enddo
? ""
? "Search complete, taking "+ltrim(str(seconds() - begin))+" seconds to search "+ltrim(str(counter))+" records."
? "Press any key to exit..."
key = inkey(45)
quit


